<?php
/* --------------------------------------------------------------
   WithdrawalApiServiceProvider.php 2020-04-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Withdrawal;

use Gambio\Admin\Withdrawal\Interfaces\WithdrawalService;
use Gambio\Api\Withdrawal\Actions\CreateWithdrawalsAction;
use Gambio\Api\Withdrawal\Actions\DeleteWithdrawalsAction;
use Gambio\Api\Withdrawal\Actions\FetchAllWithdrawalsAction;
use Gambio\Api\Withdrawal\Actions\FetchSpecificWithdrawalAction;
use Gambio\Api\Withdrawal\Actions\UpdateWithdrawalsAction;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;

/**
 * Class WithdrawalApiServiceProvider
 *
 * @package Gambio\Api\Withdrawal
 * @codeCoverageIgnore
 */
class WithdrawalApiServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            CreateWithdrawalsAction::class,
            DeleteWithdrawalsAction::class,
            FetchSpecificWithdrawalAction::class,
            FetchAllWithdrawalsAction::class,
            UpdateWithdrawalsAction::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->add(WithdrawalApiRequestParser::class);
        
        $this->application->add(WithdrawalApiRequestValidator::class);
        
        $this->application->share(CreateWithdrawalsAction::class)
            ->addArgument(WithdrawalApiRequestParser::class)
            ->addArgument(WithdrawalApiRequestValidator::class)
            ->addArgument(WithdrawalService::class);
        
        $this->application->share(DeleteWithdrawalsAction::class)->addArgument(WithdrawalService::class);
        
        $this->application->share(FetchSpecificWithdrawalAction::class)->addArgument(WithdrawalService::class);
        
        $this->application->share(FetchAllWithdrawalsAction::class)
            ->addArgument(WithdrawalApiRequestParser::class)
            ->addArgument(WithdrawalService::class);
        
        $this->application->share(UpdateWithdrawalsAction::class)
            ->addArgument(WithdrawalApiRequestValidator::class)
            ->addArgument(WithdrawalService::class);
    }
}